(() => {
    'use strict';

    // スプライトエネミーの初期処理
    const _Sprite_Enemy_init = Sprite_Enemy.prototype.initialize;
    Sprite_Enemy.prototype.initialize = function(battler) {
        _Sprite_Enemy_init.call(this, battler);
        this._lastHp = 0;
        this.createHpBar();
    };

    // HPバーの作成処理
    Sprite_Enemy.prototype.createHpBar = function() {
        // 幅と高さは後で設定するからここは適当
        this._hpBarSprite = new Sprite(new Bitmap(1, 6));
        this._hpBarSprite.anchor.x = 0.5;
        this._hpBarSprite.anchor.y = 0;
        this.addChild(this._hpBarSprite);
        this._hpBarReady = false;

        this._lastHp = this._battler.hp;
        this.refreshHpBar();
    };

    // HPバーの描画処理
    Sprite_Enemy.prototype.refreshHpBar = function() {
        const battler = this._battler;
        if (!battler) return;

        const rate = battler.hpRate(); // 0.0 ～ 1.0
        const bitmap = this._hpBarSprite.bitmap;
        bitmap.clear();
        bitmap.fillRect(0, 0, bitmap.width, bitmap.height, "#000000");
        bitmap.fillRect(1, 1, (bitmap.width - 2) * rate, bitmap.height - 2, "#ff5555");
    };

    // 更新処理
    // アップデートのたびにHPゲージを描画
    const _Sprite_Enemy_update = Sprite_Enemy.prototype.update;
    Sprite_Enemy.prototype.update = function() {
        _Sprite_Enemy_update.call(this);
        if (this._hpBarSprite) {
            const hp = this._battler.hp;

            // 前回の描画からHPに変更があった場合再描画
            if (hp !== this._lastHp) {
                this._lastHp = hp;
                this.refreshHpBar();
            }
        }
    };

    // ビットマップのアップデート処理
    const _Sprite_Enemy_updateBitmap = Sprite_Enemy.prototype.updateBitmap;
    Sprite_Enemy.prototype.updateBitmap = function() {
        _Sprite_Enemy_updateBitmap.call(this);
        this.setupHpBarBitmap();
    };

    // HPバーの位置とか設定
    // initializeではエネミーのビットマップがセットされてないから
    // 幅とかが取れない
    Sprite_Enemy.prototype.setupHpBarBitmap = function() {
        if (this._hpBarReady) return;
        if (!this.bitmap || !this.bitmap.width) return;

        const barWidth = Math.floor(this.bitmap.width * 0.8);
        const barHeight = 6;

        this._hpBarSprite.bitmap = new Bitmap(barWidth, barHeight);

        this._hpBarReady = true;
        this.refreshHpBar();
    };
})();